import java.io.*;
import java.util.*;
import javax.naming.ldap.*;
import javax.naming.directory.*;
import javax.naming.*;
import java.security.cert.*;
import java.security.*;
import java.math.*;

class getCrl
{
    public static void ShowListCert(NamingEnumeration ans)
    {
        int count=0;
        try
        {
            NamingEnumeration answer = ans;
            System.out.println(answer.hasMoreElements());
            if(answer.hasMoreElements())
            {
                System.out.println("Available certificates:");
                while(answer.hasMoreElements())
                {
                    SearchResult sr = (SearchResult)answer.next();
                    System.out.println(sr.getName());
                    System.out.println("===================================================================================================");
                    Attributes attrs = sr.getAttributes();
                    if(attrs != null)
                    {
                        Object Cert = attrs.get("certificateRevocationList").get();
                        byte[] CRTSCT = (byte[]) Cert;
                        try
                        {
                            ByteArrayInputStream bis = new ByteArrayInputStream(CRTSCT);
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            X509CRL crl = (X509CRL) cf.generateCRL(bis);
                            byte[] barr = (byte[])crl.getExtensionValue("2.5.29.20");

                            byte[] data = new byte[barr[3]];
                            for(byte i=0; i<barr[3]; i++)
                                data[i] = barr[i+4];

                            BigInteger ff =  new BigInteger(data);
                            System.out.println("serialnumber - " + ff.toString(16));
                        }
                        catch(Exception s){s.printStackTrace();}
                    }
                    count++;
                }
            }
        }
        catch(Exception e){System.out.println(e);}
        System.out.println("Count CRL: " + count);
    }
    public static void main(String args[])
    {
        try
        {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

            String arg[] = new String[4];
            int i=0;
            while(i<arg.length)
            {
                switch(i)
                {
                    case 0: System.out.print("Enter ip store: ");break;
                    case 1: System.out.print("Enter user name: ");break;
                    case 2: System.out.print("Enter user password: ");break;
                    case 3: System.out.print("Eneter DN name: ");break;
                }
                arg[i] = br.readLine();
                if(arg[i].length()!=0)
                    i++;
            }
            String ldapURL = arg[0];
            String userName = "dn:t=R;cn="+arg[1];
            String userPass = arg[2];
            String dnName = arg[3];

            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
            env.put(Context.SECURITY_AUTHENTICATION,"DIGEST-MD5");
            env.put(Context.PROVIDER_URL,ldapURL);
            env.put(Context.SECURITY_PRINCIPAL,userName);
            env.put(Context.SECURITY_CREDENTIALS,userPass);
            env.put("java.naming.ldap.attributes.binary","certificateRevocationList");

            LdapContext ctx = new InitialLdapContext(env, null);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(SearchControls.SUBTREE_SCOPE);
            NamingEnumeration answer = ctx.search(dnName, "certificateRevocationList=*", ctls);
            ShowListCert(answer);
            ctx.close();
        }
        catch(Exception e){System.out.println("Exception: "+ e +"\n Possible, there were enter not correct data");}
    }
}